﻿using System;
using System.Reflection;

namespace HIPS.Web.UI.Helpers
{

    /// <summary>
    /// Provides information about the application.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="03 December 2013">Initial version.</change>
    /// </history>
    public class AppInfo
    {

        #region Fields
        public static readonly string PublicVersion;
        public static readonly string InternalVersion;
        #endregion

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="03 December 2013">Initial version.</change>
        /// </history>
        static AppInfo()
        {
            var assemblyVersion =Assembly.GetExecutingAssembly().GetName().Version;
            var productVersion = Assembly.GetExecutingAssembly().GetCustomAttribute<AssemblyInformationalVersionAttribute>().InformationalVersion;

            PublicVersion = productVersion;
            InternalVersion = assemblyVersion.ToString();
        }

        #endregion

    }
}